package handlers

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/handler"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type PlantHandler struct {
	Handler    *handler.Handler
	PlantTable *tables.PlantTable
}

func (this *PlantHandler) Create(ctx context.Context, entity *mdl.Plant, mod *handler.HandlerMod) (*mdl.Plant, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "create")
	mod.Table = this.PlantTable.TableName()

	id, _, err := this.Handler.Create(ctx, mod)
	if err != nil {
		return nil, err
	}
	entity.Id = id
	return entity, nil
}
func (this *PlantHandler) MustCreate(ctx context.Context, entity *mdl.Plant, mod *handler.HandlerMod) *mdl.Plant {
	p1, err := this.Create(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantHandler) Update(ctx context.Context, entity *mdl.Plant, mod *handler.HandlerMod) (*mdl.Plant, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "update")
	mod.Table = this.PlantTable.TableName()
	mod.Id = entity.Id

	_, err := this.Handler.Update(ctx, mod)
	if err != nil {
		return nil, err
	}
	return entity, nil
}
func (this *PlantHandler) MustUpdate(ctx context.Context, entity *mdl.Plant, mod *handler.HandlerMod) *mdl.Plant {
	p1, err := this.Update(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantHandler) UpdateFields(ctx context.Context, entity *mdl.Plant, fields []string, mod *handler.HandlerMod) (*mdl.Plant, error) {
	mod = this.modDefaulting(mod)
	mod.Fields = fields
	return this.Update(ctx, entity, mod)
}
func (this *PlantHandler) MustUpdateFields(ctx context.Context, entity *mdl.Plant, fields []string, mod *handler.HandlerMod) *mdl.Plant {
	p1, err := this.UpdateFields(ctx, entity, fields, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantHandler) Delete(ctx context.Context, plant *mdl.Plant, mod *handler.HandlerMod) error {
	mod = this.modDefaulting(mod)
	mod.Table = this.PlantTable.TableName()
	mod.Id = plant.Id
	_, err := this.Handler.Delete(ctx, mod)
	if err != nil {
		return err
	}
	return nil
}
func (this *PlantHandler) MustDelete(ctx context.Context, plant *mdl.Plant, mod *handler.HandlerMod) {
	err := this.Delete(ctx, plant, mod)
	lib.Poe(err)
	return
}
func (this *PlantHandler) modDefaulting(mod *handler.HandlerMod) *handler.HandlerMod {
	if mod == nil {
		return &handler.HandlerMod{}
	}
	return mod
}
func (this *PlantHandler) setColumns(mod *handler.HandlerMod, entity *mdl.Plant) {
	table := this.PlantTable
	fields := mod.Fields
	if len(fields) == 0 {
		fields = table.Fields()
	}
	indexes := this.Handler.IndexesFromFields(fields, table.Fields())
	indexes = this.Handler.ExcludeUtilitiesIndexes(indexes, table.Fields())
	mod.Columns = this.Handler.StringSubsetFromIndexes(indexes, table.Columns())
	mod.Values = this.Handler.InterfaceSubsetFromIndexes(indexes, table.EntityToValues(entity))
}
func (this *PlantHandler) setUtilities(mod *handler.HandlerMod, entity *mdl.Plant, action string) {
	if action == "create" {
		this.Handler.AppendColumnValueAtNow("created_at", mod)
	}
	if action == "update" || action == "create" {
		this.Handler.AppendColumnValueAtNow("updated_at", mod)
	}
}
