package handlers

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/handler"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type PlantTaskHandler struct {
	Handler        *handler.Handler
	PlantTaskTable *tables.PlantTaskTable
}

func (this *PlantTaskHandler) Create(ctx context.Context, entity *mdl.PlantTask, mod *handler.HandlerMod) (*mdl.PlantTask, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "create")
	mod.Table = this.PlantTaskTable.TableName()

	id, _, err := this.Handler.Create(ctx, mod)
	if err != nil {
		return nil, err
	}
	entity.Id = id
	return entity, nil
}
func (this *PlantTaskHandler) MustCreate(ctx context.Context, entity *mdl.PlantTask, mod *handler.HandlerMod) *mdl.PlantTask {
	p1, err := this.Create(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantTaskHandler) Update(ctx context.Context, entity *mdl.PlantTask, mod *handler.HandlerMod) (*mdl.PlantTask, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "update")
	mod.Table = this.PlantTaskTable.TableName()
	mod.Id = entity.Id

	_, err := this.Handler.Update(ctx, mod)
	if err != nil {
		return nil, err
	}
	return entity, nil
}
func (this *PlantTaskHandler) MustUpdate(ctx context.Context, entity *mdl.PlantTask, mod *handler.HandlerMod) *mdl.PlantTask {
	p1, err := this.Update(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantTaskHandler) UpdateFields(ctx context.Context, entity *mdl.PlantTask, fields []string, mod *handler.HandlerMod) (*mdl.PlantTask, error) {
	mod = this.modDefaulting(mod)
	mod.Fields = fields
	return this.Update(ctx, entity, mod)
}
func (this *PlantTaskHandler) MustUpdateFields(ctx context.Context, entity *mdl.PlantTask, fields []string, mod *handler.HandlerMod) *mdl.PlantTask {
	p1, err := this.UpdateFields(ctx, entity, fields, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantTaskHandler) Delete(ctx context.Context, plantTask *mdl.PlantTask, mod *handler.HandlerMod) error {
	mod = this.modDefaulting(mod)
	mod.Table = this.PlantTaskTable.TableName()
	mod.Id = plantTask.Id
	_, err := this.Handler.Delete(ctx, mod)
	if err != nil {
		return err
	}
	return nil
}
func (this *PlantTaskHandler) MustDelete(ctx context.Context, plantTask *mdl.PlantTask, mod *handler.HandlerMod) {
	err := this.Delete(ctx, plantTask, mod)
	lib.Poe(err)
	return
}
func (this *PlantTaskHandler) modDefaulting(mod *handler.HandlerMod) *handler.HandlerMod {
	if mod == nil {
		return &handler.HandlerMod{}
	}
	return mod
}
func (this *PlantTaskHandler) setColumns(mod *handler.HandlerMod, entity *mdl.PlantTask) {
	table := this.PlantTaskTable
	fields := mod.Fields
	if len(fields) == 0 {
		fields = table.Fields()
	}
	indexes := this.Handler.IndexesFromFields(fields, table.Fields())
	indexes = this.Handler.ExcludeUtilitiesIndexes(indexes, table.Fields())
	mod.Columns = this.Handler.StringSubsetFromIndexes(indexes, table.Columns())
	mod.Values = this.Handler.InterfaceSubsetFromIndexes(indexes, table.EntityToValues(entity))
}
func (this *PlantTaskHandler) setUtilities(mod *handler.HandlerMod, entity *mdl.PlantTask, action string) {
	if action == "create" {
		this.Handler.AppendColumnValueAtNow("created_at", mod)
	}
	if action == "update" || action == "create" {
		this.Handler.AppendColumnValueAtNow("updated_at", mod)
	}
}
