package handlers

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/handler"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type PlantationHandler struct {
	Handler         *handler.Handler
	PlantationTable *tables.PlantationTable
}

func (this *PlantationHandler) Create(ctx context.Context, entity *mdl.Plantation, mod *handler.HandlerMod) (*mdl.Plantation, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "create")
	mod.Table = this.PlantationTable.TableName()

	id, _, err := this.Handler.Create(ctx, mod)
	if err != nil {
		return nil, err
	}
	entity.Id = id
	return entity, nil
}
func (this *PlantationHandler) MustCreate(ctx context.Context, entity *mdl.Plantation, mod *handler.HandlerMod) *mdl.Plantation {
	p1, err := this.Create(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantationHandler) Update(ctx context.Context, entity *mdl.Plantation, mod *handler.HandlerMod) (*mdl.Plantation, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "update")
	mod.Table = this.PlantationTable.TableName()
	mod.Id = entity.Id

	_, err := this.Handler.Update(ctx, mod)
	if err != nil {
		return nil, err
	}
	return entity, nil
}
func (this *PlantationHandler) MustUpdate(ctx context.Context, entity *mdl.Plantation, mod *handler.HandlerMod) *mdl.Plantation {
	p1, err := this.Update(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantationHandler) UpdateFields(ctx context.Context, entity *mdl.Plantation, fields []string, mod *handler.HandlerMod) (*mdl.Plantation, error) {
	mod = this.modDefaulting(mod)
	mod.Fields = fields
	return this.Update(ctx, entity, mod)
}
func (this *PlantationHandler) MustUpdateFields(ctx context.Context, entity *mdl.Plantation, fields []string, mod *handler.HandlerMod) *mdl.Plantation {
	p1, err := this.UpdateFields(ctx, entity, fields, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantationHandler) Delete(ctx context.Context, plantation *mdl.Plantation, mod *handler.HandlerMod) error {
	mod = this.modDefaulting(mod)
	mod.Table = this.PlantationTable.TableName()
	mod.Id = plantation.Id
	_, err := this.Handler.Delete(ctx, mod)
	if err != nil {
		return err
	}
	return nil
}
func (this *PlantationHandler) MustDelete(ctx context.Context, plantation *mdl.Plantation, mod *handler.HandlerMod) {
	err := this.Delete(ctx, plantation, mod)
	lib.Poe(err)
	return
}
func (this *PlantationHandler) modDefaulting(mod *handler.HandlerMod) *handler.HandlerMod {
	if mod == nil {
		return &handler.HandlerMod{}
	}
	return mod
}
func (this *PlantationHandler) setColumns(mod *handler.HandlerMod, entity *mdl.Plantation) {
	table := this.PlantationTable
	fields := mod.Fields
	if len(fields) == 0 {
		fields = table.Fields()
	}
	indexes := this.Handler.IndexesFromFields(fields, table.Fields())
	indexes = this.Handler.ExcludeUtilitiesIndexes(indexes, table.Fields())
	mod.Columns = this.Handler.StringSubsetFromIndexes(indexes, table.Columns())
	mod.Values = this.Handler.InterfaceSubsetFromIndexes(indexes, table.EntityToValues(entity))
}
func (this *PlantationHandler) setUtilities(mod *handler.HandlerMod, entity *mdl.Plantation, action string) {
	if action == "create" {
		this.Handler.AppendColumnValueAtNow("created_at", mod)
	}
	if action == "update" || action == "create" {
		this.Handler.AppendColumnValueAtNow("updated_at", mod)
	}
}
