package handlers

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/handler"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type SeedProgramHandler struct {
	Handler          *handler.Handler
	SeedProgramTable *tables.SeedProgramTable
}

func (this *SeedProgramHandler) Create(ctx context.Context, entity *mdl.SeedProgram, mod *handler.HandlerMod) (*mdl.SeedProgram, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "create")
	mod.Table = this.SeedProgramTable.TableName()

	id, _, err := this.Handler.Create(ctx, mod)
	if err != nil {
		return nil, err
	}
	entity.Id = id
	return entity, nil
}
func (this *SeedProgramHandler) MustCreate(ctx context.Context, entity *mdl.SeedProgram, mod *handler.HandlerMod) *mdl.SeedProgram {
	p1, err := this.Create(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *SeedProgramHandler) Update(ctx context.Context, entity *mdl.SeedProgram, mod *handler.HandlerMod) (*mdl.SeedProgram, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "update")
	mod.Table = this.SeedProgramTable.TableName()
	mod.Id = entity.Id

	_, err := this.Handler.Update(ctx, mod)
	if err != nil {
		return nil, err
	}
	return entity, nil
}
func (this *SeedProgramHandler) MustUpdate(ctx context.Context, entity *mdl.SeedProgram, mod *handler.HandlerMod) *mdl.SeedProgram {
	p1, err := this.Update(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *SeedProgramHandler) UpdateFields(ctx context.Context, entity *mdl.SeedProgram, fields []string, mod *handler.HandlerMod) (*mdl.SeedProgram, error) {
	mod = this.modDefaulting(mod)
	mod.Fields = fields
	return this.Update(ctx, entity, mod)
}
func (this *SeedProgramHandler) MustUpdateFields(ctx context.Context, entity *mdl.SeedProgram, fields []string, mod *handler.HandlerMod) *mdl.SeedProgram {
	p1, err := this.UpdateFields(ctx, entity, fields, mod)
	lib.Poe(err)
	return p1
}
func (this *SeedProgramHandler) Delete(ctx context.Context, seedProgram *mdl.SeedProgram, mod *handler.HandlerMod) error {
	mod = this.modDefaulting(mod)
	mod.Table = this.SeedProgramTable.TableName()
	mod.Id = seedProgram.Id
	_, err := this.Handler.Delete(ctx, mod)
	if err != nil {
		return err
	}
	return nil
}
func (this *SeedProgramHandler) MustDelete(ctx context.Context, seedProgram *mdl.SeedProgram, mod *handler.HandlerMod) {
	err := this.Delete(ctx, seedProgram, mod)
	lib.Poe(err)
	return
}
func (this *SeedProgramHandler) modDefaulting(mod *handler.HandlerMod) *handler.HandlerMod {
	if mod == nil {
		return &handler.HandlerMod{}
	}
	return mod
}
func (this *SeedProgramHandler) setColumns(mod *handler.HandlerMod, entity *mdl.SeedProgram) {
	table := this.SeedProgramTable
	fields := mod.Fields
	if len(fields) == 0 {
		fields = table.Fields()
	}
	indexes := this.Handler.IndexesFromFields(fields, table.Fields())
	indexes = this.Handler.ExcludeUtilitiesIndexes(indexes, table.Fields())
	mod.Columns = this.Handler.StringSubsetFromIndexes(indexes, table.Columns())
	mod.Values = this.Handler.InterfaceSubsetFromIndexes(indexes, table.EntityToValues(entity))
}
func (this *SeedProgramHandler) setUtilities(mod *handler.HandlerMod, entity *mdl.SeedProgram, action string) {
	if action == "create" {
		this.Handler.AppendColumnValueAtNow("created_at", mod)
	}
	if action == "update" || action == "create" {
		this.Handler.AppendColumnValueAtNow("updated_at", mod)
	}
}
