package handlers

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/handler"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type UserHandler struct {
	Handler   *handler.Handler
	UserTable *tables.UserTable
}

func (this *UserHandler) Create(ctx context.Context, entity *mdl.User, mod *handler.HandlerMod) (*mdl.User, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "create")
	mod.Table = this.UserTable.TableName()

	id, _, err := this.Handler.Create(ctx, mod)
	if err != nil {
		return nil, err
	}
	entity.Id = id
	return entity, nil
}
func (this *UserHandler) MustCreate(ctx context.Context, entity *mdl.User, mod *handler.HandlerMod) *mdl.User {
	p1, err := this.Create(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *UserHandler) Update(ctx context.Context, entity *mdl.User, mod *handler.HandlerMod) (*mdl.User, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "update")
	mod.Table = this.UserTable.TableName()
	mod.Id = entity.Id

	_, err := this.Handler.Update(ctx, mod)
	if err != nil {
		return nil, err
	}
	return entity, nil
}
func (this *UserHandler) MustUpdate(ctx context.Context, entity *mdl.User, mod *handler.HandlerMod) *mdl.User {
	p1, err := this.Update(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *UserHandler) UpdateFields(ctx context.Context, entity *mdl.User, fields []string, mod *handler.HandlerMod) (*mdl.User, error) {
	mod = this.modDefaulting(mod)
	mod.Fields = fields
	return this.Update(ctx, entity, mod)
}
func (this *UserHandler) MustUpdateFields(ctx context.Context, entity *mdl.User, fields []string, mod *handler.HandlerMod) *mdl.User {
	p1, err := this.UpdateFields(ctx, entity, fields, mod)
	lib.Poe(err)
	return p1
}
func (this *UserHandler) Delete(ctx context.Context, user *mdl.User, mod *handler.HandlerMod) error {
	mod = this.modDefaulting(mod)
	mod.Table = this.UserTable.TableName()
	mod.Id = user.Id
	_, err := this.Handler.Delete(ctx, mod)
	if err != nil {
		return err
	}
	return nil
}
func (this *UserHandler) MustDelete(ctx context.Context, user *mdl.User, mod *handler.HandlerMod) {
	err := this.Delete(ctx, user, mod)
	lib.Poe(err)
	return
}
func (this *UserHandler) modDefaulting(mod *handler.HandlerMod) *handler.HandlerMod {
	if mod == nil {
		return &handler.HandlerMod{}
	}
	return mod
}
func (this *UserHandler) setColumns(mod *handler.HandlerMod, entity *mdl.User) {
	table := this.UserTable
	fields := mod.Fields
	if len(fields) == 0 {
		fields = table.Fields()
	}
	indexes := this.Handler.IndexesFromFields(fields, table.Fields())
	indexes = this.Handler.ExcludeUtilitiesIndexes(indexes, table.Fields())
	mod.Columns = this.Handler.StringSubsetFromIndexes(indexes, table.Columns())
	mod.Values = this.Handler.InterfaceSubsetFromIndexes(indexes, table.EntityToValues(entity))
}
func (this *UserHandler) setUtilities(mod *handler.HandlerMod, entity *mdl.User, action string) {
	if action == "create" {
		this.Handler.AppendColumnValueAtNow("created_at", mod)
	}
	if action == "update" || action == "create" {
		this.Handler.AppendColumnValueAtNow("updated_at", mod)
	}
}
