package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/display_weather_forecast"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type DisplayWeatherForecastView struct {
	DisplaySection *sections.DisplaySection
	Kit            *kit.Kit
	TiledLayout    *layouts.TiledLayout
	TitleSection   *sections.TitleSection
}

func (this *DisplayWeatherForecastView) H(out *maes.DisplayWeatherForecastMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *DisplayWeatherForecastView) tiling(out *maes.DisplayWeatherForecastMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.DisplaySection.H(out),
	)

	return root
}
func (this *DisplayWeatherForecastView) configureBreadcrumb(out *maes.DisplayWeatherForecastMaeOut, mod *layouts.LayoutMod) {
}
