package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/edit_plant_task"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type EditPlantTaskView struct {
	AppUrler     *urlers.AppUrler
	FormSection  *sections.FormSection
	Kit          *kit.Kit
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *EditPlantTaskView) H(out *maes.EditPlantTaskMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *EditPlantTaskView) tiling(out *maes.EditPlantTaskMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.FormSection.H(out),
	)

	return root
}
func (this *EditPlantTaskView) configureBreadcrumb(out *maes.EditPlantTaskMaeOut, mod *layouts.LayoutMod) {

	i0 := &navbars.BreadcrumbItem{Label: "Plant Tasks", Link: this.AppUrler.ListPlantTasks()}
	i1 := &navbars.BreadcrumbItem{Label: "Edit", Link: "#"}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
