package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/home"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type HomeView struct {
	GardensSection *sections.GardensSection
	GridSection    *sections.GridSection
	Kit            *kit.Kit
	TiledLayout    *layouts.TiledLayout
	TitleSection   *sections.TitleSection
}

func (this *HomeView) H(out *maes.HomeMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *HomeView) tiling(out *maes.HomeMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.GridSection.H(out),
		this.GardensSection.H(out),
	)

	return root
}
func (this *HomeView) configureBreadcrumb(out *maes.HomeMaeOut, mod *layouts.LayoutMod) {
}
