package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/list_garden_tasks"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListGardenTasksView struct {
	AppUrler     *urlers.AppUrler
	Kit          *kit.Kit
	ListSection  *sections.ListSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *ListGardenTasksView) H(out *maes.ListGardenTasksMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ListGardenTasksView) tiling(out *maes.ListGardenTasksMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ListSection.H(out),
	)

	return root
}
func (this *ListGardenTasksView) configureBreadcrumb(out *maes.ListGardenTasksMaeOut, mod *layouts.LayoutMod) {

	i0 := &navbars.BreadcrumbItem{Label: "Garden Tasks", Link: this.AppUrler.ListGardenTasks()}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0)

}
