package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/list_plant_tasks"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListPlantTasksView struct {
	AppUrler     *urlers.AppUrler
	Kit          *kit.Kit
	ListSection  *sections.ListSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *ListPlantTasksView) H(out *maes.ListPlantTasksMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ListPlantTasksView) tiling(out *maes.ListPlantTasksMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ListSection.H(out),
	)

	return root
}
func (this *ListPlantTasksView) configureBreadcrumb(out *maes.ListPlantTasksMaeOut, mod *layouts.LayoutMod) {

	i0 := &navbars.BreadcrumbItem{Label: "Plant Tasks", Link: this.AppUrler.ListPlantTasks()}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0)

}
