package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/list_plantations"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListPlantationsView struct {
	AppUrler     *urlers.AppUrler
	Kit          *kit.Kit
	ListSection  *sections.ListSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *ListPlantationsView) H(out *maes.ListPlantationsMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ListPlantationsView) tiling(out *maes.ListPlantationsMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ListSection.H(out),
	)

	return root
}
func (this *ListPlantationsView) configureBreadcrumb(out *maes.ListPlantationsMaeOut, mod *layouts.LayoutMod) {

	i0 := &navbars.BreadcrumbItem{Label: "Plantations", Link: this.AppUrler.ListPlantations()}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0)

}
