package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/list_seed_programs"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListSeedProgramsView struct {
	AppUrler     *urlers.AppUrler
	Kit          *kit.Kit
	ListSection  *sections.ListSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *ListSeedProgramsView) H(out *maes.ListSeedProgramsMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ListSeedProgramsView) tiling(out *maes.ListSeedProgramsMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ListSection.H(out),
	)

	return root
}
func (this *ListSeedProgramsView) configureBreadcrumb(out *maes.ListSeedProgramsMaeOut, mod *layouts.LayoutMod) {

	i0 := &navbars.BreadcrumbItem{Label: "Seed Programs", Link: this.AppUrler.ListSeedPrograms()}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0)

}
