package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/new_garden_task"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type NewGardenTaskView struct {
	AppUrler     *urlers.AppUrler
	FormSection  *sections.FormSection
	Kit          *kit.Kit
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *NewGardenTaskView) H(out *maes.NewGardenTaskMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *NewGardenTaskView) tiling(out *maes.NewGardenTaskMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.FormSection.H(out),
	)

	return root
}
func (this *NewGardenTaskView) configureBreadcrumb(out *maes.NewGardenTaskMaeOut, mod *layouts.LayoutMod) {

	i0 := &navbars.BreadcrumbItem{Label: "Garden Tasks", Link: this.AppUrler.ListGardenTasks()}
	i1 := &navbars.BreadcrumbItem{Label: "New", Link: "#"}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
