package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/overview_storage"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type OverviewStorageView struct {
	Kit             *kit.Kit
	OverviewSection *sections.OverviewSection
	TiledLayout     *layouts.TiledLayout
	TitleSection    *sections.TitleSection
}

func (this *OverviewStorageView) H(out *maes.OverviewStorageMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *OverviewStorageView) tiling(out *maes.OverviewStorageMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.OverviewSection.H(out),
	)

	return root
}
func (this *OverviewStorageView) configureBreadcrumb(out *maes.OverviewStorageMaeOut, mod *layouts.LayoutMod) {
}
