package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/see_planner"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeePlannerView struct {
	FormSection  *sections.FormSection
	Kit          *kit.Kit
	SeeSection   *sections.SeeSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *SeePlannerView) H(out *maes.SeePlannerMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *SeePlannerView) tiling(out *maes.SeePlannerMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.SeeSection.H(out),
		this.FormSection.H(out),
	)

	return root
}
func (this *SeePlannerView) configureBreadcrumb(out *maes.SeePlannerMaeOut, mod *layouts.LayoutMod) {
}
