package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/see_renew_orders"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeeRenewOrdersView struct {
	FormSection           *sections.FormSection
	Kit                   *kit.Kit
	PreviousOrdersSection *sections.PreviousOrdersSection
	SeeSection            *sections.SeeSection
	TiledLayout           *layouts.TiledLayout
	TitleSection          *sections.TitleSection
}

func (this *SeeRenewOrdersView) H(out *maes.SeeRenewOrdersMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *SeeRenewOrdersView) tiling(out *maes.SeeRenewOrdersMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.SeeSection.H(out),
		this.FormSection.H(out),
		this.PreviousOrdersSection.H(out),
	)

	return root
}
func (this *SeeRenewOrdersView) configureBreadcrumb(out *maes.SeeRenewOrdersMaeOut, mod *layouts.LayoutMod) {
}
