package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/show_garden_task"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowGardenTaskView struct {
	AppUrler     *urlers.AppUrler
	Kit          *kit.Kit
	ShowSection  *sections.ShowSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *ShowGardenTaskView) H(out *maes.ShowGardenTaskMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ShowGardenTaskView) tiling(out *maes.ShowGardenTaskMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ShowSection.H(out),
	)

	return root
}
func (this *ShowGardenTaskView) configureBreadcrumb(out *maes.ShowGardenTaskMaeOut, mod *layouts.LayoutMod) {
	items := out.Extra.Navigation.Breadcrumb.Items
	gardenTask := items[0].(*mdl.GardenTask)

	i0 := &navbars.BreadcrumbItem{Label: "Garden Tasks", Link: this.AppUrler.ListGardenTasks()}
	i1 := &navbars.BreadcrumbItem{Label: gardenTask.Name, Link: this.AppUrler.ShowGardenTask(gardenTask.Id)}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
