package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/show_garden"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowGardenView struct {
	AppUrler               *urlers.AppUrler
	GardenTasksListSection *sections.GardenTasksListSection
	Kit                    *kit.Kit
	PlantationsListSection *sections.PlantationsListSection
	ShowSection            *sections.ShowSection
	TiledLayout            *layouts.TiledLayout
	TitleSection           *sections.TitleSection
}

func (this *ShowGardenView) H(out *maes.ShowGardenMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ShowGardenView) tiling(out *maes.ShowGardenMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ShowSection.H(out),
		this.GardenTasksListSection.H(out),
		this.PlantationsListSection.H(out),
	)

	return root
}
func (this *ShowGardenView) configureBreadcrumb(out *maes.ShowGardenMaeOut, mod *layouts.LayoutMod) {
	items := out.Extra.Navigation.Breadcrumb.Items
	garden := items[0].(*mdl.Garden)

	i0 := &navbars.BreadcrumbItem{Label: "Gardens", Link: this.AppUrler.ListGardens()}
	i1 := &navbars.BreadcrumbItem{Label: garden.Name, Link: this.AppUrler.ShowGarden(garden.Id)}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
