package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/show_plant_task"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowPlantTaskView struct {
	AppUrler     *urlers.AppUrler
	Kit          *kit.Kit
	ShowSection  *sections.ShowSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *ShowPlantTaskView) H(out *maes.ShowPlantTaskMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ShowPlantTaskView) tiling(out *maes.ShowPlantTaskMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ShowSection.H(out),
	)

	return root
}
func (this *ShowPlantTaskView) configureBreadcrumb(out *maes.ShowPlantTaskMaeOut, mod *layouts.LayoutMod) {
	items := out.Extra.Navigation.Breadcrumb.Items
	plantTask := items[0].(*mdl.PlantTask)

	i0 := &navbars.BreadcrumbItem{Label: "Plant Tasks", Link: this.AppUrler.ListPlantTasks()}
	i1 := &navbars.BreadcrumbItem{Label: plantTask.Name, Link: this.AppUrler.ShowPlantTask(plantTask.Id)}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
