package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/show_plant"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowPlantView struct {
	AppUrler                *urlers.AppUrler
	Kit                     *kit.Kit
	PlantTasksListSection   *sections.PlantTasksListSection
	PlantationsListSection  *sections.PlantationsListSection
	SeedProgramsListSection *sections.SeedProgramsListSection
	ShowSection             *sections.ShowSection
	TiledLayout             *layouts.TiledLayout
	TitleSection            *sections.TitleSection
}

func (this *ShowPlantView) H(out *maes.ShowPlantMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ShowPlantView) tiling(out *maes.ShowPlantMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ShowSection.H(out),
		this.PlantTasksListSection.H(out),
		this.PlantationsListSection.H(out),
		this.SeedProgramsListSection.H(out),
	)

	return root
}
func (this *ShowPlantView) configureBreadcrumb(out *maes.ShowPlantMaeOut, mod *layouts.LayoutMod) {
	items := out.Extra.Navigation.Breadcrumb.Items
	plant := items[0].(*mdl.Plant)

	i0 := &navbars.BreadcrumbItem{Label: "Plants", Link: this.AppUrler.ListPlants()}
	i1 := &navbars.BreadcrumbItem{Label: plant.Name, Link: this.AppUrler.ShowPlant(plant.Id)}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
