package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/show_plantation"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowPlantationView struct {
	AppUrler               *urlers.AppUrler
	GardenTasksListSection *sections.GardenTasksListSection
	Kit                    *kit.Kit
	ShowSection            *sections.ShowSection
	TiledLayout            *layouts.TiledLayout
	TitleSection           *sections.TitleSection
}

func (this *ShowPlantationView) H(out *maes.ShowPlantationMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ShowPlantationView) tiling(out *maes.ShowPlantationMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ShowSection.H(out),
		this.GardenTasksListSection.H(out),
	)

	return root
}
func (this *ShowPlantationView) configureBreadcrumb(out *maes.ShowPlantationMaeOut, mod *layouts.LayoutMod) {
	items := out.Extra.Navigation.Breadcrumb.Items
	plantation := items[0].(*mdl.Plantation)

	i0 := &navbars.BreadcrumbItem{Label: "Plantations", Link: this.AppUrler.ListPlantations()}
	i1 := &navbars.BreadcrumbItem{Label: plantation.Name, Link: this.AppUrler.ShowPlantation(plantation.Id)}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
