package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/show_seed_program"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowSeedProgramView struct {
	AppUrler     *urlers.AppUrler
	Kit          *kit.Kit
	ShowSection  *sections.ShowSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *ShowSeedProgramView) H(out *maes.ShowSeedProgramMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ShowSeedProgramView) tiling(out *maes.ShowSeedProgramMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ShowSection.H(out),
	)

	return root
}
func (this *ShowSeedProgramView) configureBreadcrumb(out *maes.ShowSeedProgramMaeOut, mod *layouts.LayoutMod) {
	items := out.Extra.Navigation.Breadcrumb.Items
	seedProgram := items[0].(*mdl.SeedProgram)

	i0 := &navbars.BreadcrumbItem{Label: "Seed Programs", Link: this.AppUrler.ListSeedPrograms()}
	i1 := &navbars.BreadcrumbItem{Label: seedProgram.Name, Link: this.AppUrler.ShowSeedProgram(seedProgram.Id)}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
