package html_views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/layouts"
	"gardening/src/srv/sections/show_user"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/components/organisms/navbars"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowUserView struct {
	AppUrler     *urlers.AppUrler
	Kit          *kit.Kit
	ShowSection  *sections.ShowSection
	TiledLayout  *layouts.TiledLayout
	TitleSection *sections.TitleSection
}

func (this *ShowUserView) H(out *maes.ShowUserMaeOut) goc.HTML {
	mod := &layouts.LayoutMod{Messages: out.Extra.Messages, Scope: out.Extra.Scope, Ctx: out.Ctx}
	this.configureBreadcrumb(out, mod)
	return this.TiledLayout.H(this.tiling(out), mod)
}
func (this *ShowUserView) tiling(out *maes.ShowUserMaeOut) goc.HTML {
	component := this.Kit.Component

	root := component.Dcs("flex flex-col space-y-4",
		this.TitleSection.H(out),
		this.ShowSection.H(out),
	)

	return root
}
func (this *ShowUserView) configureBreadcrumb(out *maes.ShowUserMaeOut, mod *layouts.LayoutMod) {
	items := out.Extra.Navigation.Breadcrumb.Items
	user := items[0].(*mdl.User)

	i0 := &navbars.BreadcrumbItem{Label: "Users", Link: this.AppUrler.ListUsers()}
	i1 := &navbars.BreadcrumbItem{Label: user.Name, Link: this.AppUrler.ShowUser(user.Id)}
	mod.BreadcrumbItems = append(mod.BreadcrumbItems, i0, i1)

}
