package hydrators

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/error"
	"gardening/src/lib/hydrator"
	"gardening/src/mdl"
)

type EventHydrator struct {
	Hydrator *hydrator.Hydrator
}

func (this *EventHydrator) Many(ctx context.Context, entities []*mdl.Event, mod *hydrator.HydratorMod) error {
	return nil
}
func (this *EventHydrator) One(ctx context.Context, entity *mdl.Event, mod *hydrator.HydratorMod) error {
	return this.Many(ctx, []*mdl.Event{entity}, mod)
}
func (this *EventHydrator) OneViaPreset(ctx context.Context, entity *mdl.Event, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.One(ctx, entity, mod)
}
func (this *EventHydrator) MustOneViaPreset(ctx context.Context, entity *mdl.Event, preset string, mod *hydrator.HydratorMod) {
	err := this.OneViaPreset(ctx, entity, preset, mod)
	lib.Poe(err)
	return
}
func (this *EventHydrator) ManyViaPreset(ctx context.Context, entities []*mdl.Event, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.Many(ctx, entities, mod)
}
func (this *EventHydrator) MustManyViaPreset(ctx context.Context, entities []*mdl.Event, preset string, mod *hydrator.HydratorMod) {
	err := this.ManyViaPreset(ctx, entities, preset, mod)
	lib.Poe(err)
	return
}
func (this *EventHydrator) presetSwitch(preset string, mod *hydrator.HydratorMod) {
	switch preset {
	case "show":
		this.showPreset(mod)
	case "list":
		this.listPreset(mod)
	default:
		erro.P(erro.N("Invalid preset"))
	}
}
func (this *EventHydrator) showPreset(mod *hydrator.HydratorMod) {
	this.oneRelations(mod)
}
func (this *EventHydrator) listPreset(mod *hydrator.HydratorMod) {
	this.selfRelations(mod)
}
func (this *EventHydrator) selfRelations(mod *hydrator.HydratorMod) {
}
func (this *EventHydrator) oneRelations(mod *hydrator.HydratorMod) {
}
