package hydrators

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/error"
	"gardening/src/lib/hydrator"
	"gardening/src/mdl"
	"gardening/src/srv/relationers"
)

type GardenHydrator struct {
	GardenRelationer *relationers.GardenRelationer
	Hydrator         *hydrator.Hydrator
}

func (this *GardenHydrator) Many(ctx context.Context, entities []*mdl.Garden, mod *hydrator.HydratorMod) error {
	if mod.Contains("garden_tasks") {
		this.GardenRelationer.HydrateGardenTasks(ctx, entities, nil)
	}
	if mod.Contains("plantations") {
		this.GardenRelationer.HydratePlantations(ctx, entities, nil)
	}
	return nil
}
func (this *GardenHydrator) One(ctx context.Context, entity *mdl.Garden, mod *hydrator.HydratorMod) error {
	return this.Many(ctx, []*mdl.Garden{entity}, mod)
}
func (this *GardenHydrator) OneViaPreset(ctx context.Context, entity *mdl.Garden, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.One(ctx, entity, mod)
}
func (this *GardenHydrator) MustOneViaPreset(ctx context.Context, entity *mdl.Garden, preset string, mod *hydrator.HydratorMod) {
	err := this.OneViaPreset(ctx, entity, preset, mod)
	lib.Poe(err)
	return
}
func (this *GardenHydrator) ManyViaPreset(ctx context.Context, entities []*mdl.Garden, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.Many(ctx, entities, mod)
}
func (this *GardenHydrator) MustManyViaPreset(ctx context.Context, entities []*mdl.Garden, preset string, mod *hydrator.HydratorMod) {
	err := this.ManyViaPreset(ctx, entities, preset, mod)
	lib.Poe(err)
	return
}
func (this *GardenHydrator) presetSwitch(preset string, mod *hydrator.HydratorMod) {
	switch preset {
	case "show":
		this.showPreset(mod)
	case "list":
		this.listPreset(mod)
	default:
		erro.P(erro.N("Invalid preset"))
	}
}
func (this *GardenHydrator) showPreset(mod *hydrator.HydratorMod) {
	this.oneRelations(mod)
}
func (this *GardenHydrator) listPreset(mod *hydrator.HydratorMod) {
	this.selfRelations(mod)
}
func (this *GardenHydrator) selfRelations(mod *hydrator.HydratorMod) {
}
func (this *GardenHydrator) oneRelations(mod *hydrator.HydratorMod) {
}
