package hydrators

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/error"
	"gardening/src/lib/hydrator"
	"gardening/src/mdl"
	"gardening/src/srv/relationers"
)

type GardenTaskHydrator struct {
	GardenTaskRelationer *relationers.GardenTaskRelationer
	Hydrator             *hydrator.Hydrator
}

func (this *GardenTaskHydrator) Many(ctx context.Context, entities []*mdl.GardenTask, mod *hydrator.HydratorMod) error {
	if mod.Contains("garden") {
		this.GardenTaskRelationer.HydrateGarden(ctx, entities, nil)
	}
	if mod.Contains("plantation") {
		this.GardenTaskRelationer.HydratePlantation(ctx, entities, nil)
	}
	return nil
}
func (this *GardenTaskHydrator) One(ctx context.Context, entity *mdl.GardenTask, mod *hydrator.HydratorMod) error {
	return this.Many(ctx, []*mdl.GardenTask{entity}, mod)
}
func (this *GardenTaskHydrator) OneViaPreset(ctx context.Context, entity *mdl.GardenTask, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.One(ctx, entity, mod)
}
func (this *GardenTaskHydrator) MustOneViaPreset(ctx context.Context, entity *mdl.GardenTask, preset string, mod *hydrator.HydratorMod) {
	err := this.OneViaPreset(ctx, entity, preset, mod)
	lib.Poe(err)
	return
}
func (this *GardenTaskHydrator) ManyViaPreset(ctx context.Context, entities []*mdl.GardenTask, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.Many(ctx, entities, mod)
}
func (this *GardenTaskHydrator) MustManyViaPreset(ctx context.Context, entities []*mdl.GardenTask, preset string, mod *hydrator.HydratorMod) {
	err := this.ManyViaPreset(ctx, entities, preset, mod)
	lib.Poe(err)
	return
}
func (this *GardenTaskHydrator) presetSwitch(preset string, mod *hydrator.HydratorMod) {
	switch preset {
	case "show":
		this.showPreset(mod)
	case "list":
		this.listPreset(mod)
	default:
		erro.P(erro.N("Invalid preset"))
	}
}
func (this *GardenTaskHydrator) showPreset(mod *hydrator.HydratorMod) {
	this.oneRelations(mod)
}
func (this *GardenTaskHydrator) listPreset(mod *hydrator.HydratorMod) {
	this.selfRelations(mod)
}
func (this *GardenTaskHydrator) selfRelations(mod *hydrator.HydratorMod) {
	mod.AddHydratingPath("garden")
	mod.AddHydratingPath("plantation")
}
func (this *GardenTaskHydrator) oneRelations(mod *hydrator.HydratorMod) {
	mod.AddHydratingPath("garden")
	mod.AddHydratingPath("plantation")
}
