package hydrators

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/error"
	"gardening/src/lib/hydrator"
	"gardening/src/mdl"
	"gardening/src/srv/relationers"
)

type PlantHydrator struct {
	Hydrator        *hydrator.Hydrator
	PlantRelationer *relationers.PlantRelationer
}

func (this *PlantHydrator) Many(ctx context.Context, entities []*mdl.Plant, mod *hydrator.HydratorMod) error {
	if mod.Contains("plant_tasks") {
		this.PlantRelationer.HydratePlantTasks(ctx, entities, nil)
	}
	if mod.Contains("plantations") {
		this.PlantRelationer.HydratePlantations(ctx, entities, nil)
	}
	if mod.Contains("seed_programs") {
		this.PlantRelationer.HydrateSeedPrograms(ctx, entities, nil)
	}
	return nil
}
func (this *PlantHydrator) One(ctx context.Context, entity *mdl.Plant, mod *hydrator.HydratorMod) error {
	return this.Many(ctx, []*mdl.Plant{entity}, mod)
}
func (this *PlantHydrator) OneViaPreset(ctx context.Context, entity *mdl.Plant, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.One(ctx, entity, mod)
}
func (this *PlantHydrator) MustOneViaPreset(ctx context.Context, entity *mdl.Plant, preset string, mod *hydrator.HydratorMod) {
	err := this.OneViaPreset(ctx, entity, preset, mod)
	lib.Poe(err)
	return
}
func (this *PlantHydrator) ManyViaPreset(ctx context.Context, entities []*mdl.Plant, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.Many(ctx, entities, mod)
}
func (this *PlantHydrator) MustManyViaPreset(ctx context.Context, entities []*mdl.Plant, preset string, mod *hydrator.HydratorMod) {
	err := this.ManyViaPreset(ctx, entities, preset, mod)
	lib.Poe(err)
	return
}
func (this *PlantHydrator) presetSwitch(preset string, mod *hydrator.HydratorMod) {
	switch preset {
	case "show":
		this.showPreset(mod)
	case "list":
		this.listPreset(mod)
	default:
		erro.P(erro.N("Invalid preset"))
	}
}
func (this *PlantHydrator) showPreset(mod *hydrator.HydratorMod) {
	this.oneRelations(mod)
}
func (this *PlantHydrator) listPreset(mod *hydrator.HydratorMod) {
	this.selfRelations(mod)
}
func (this *PlantHydrator) selfRelations(mod *hydrator.HydratorMod) {
}
func (this *PlantHydrator) oneRelations(mod *hydrator.HydratorMod) {
}
