package hydrators

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/error"
	"gardening/src/lib/hydrator"
	"gardening/src/mdl"
	"gardening/src/srv/relationers"
)

type PlantTaskHydrator struct {
	Hydrator            *hydrator.Hydrator
	PlantTaskRelationer *relationers.PlantTaskRelationer
}

func (this *PlantTaskHydrator) Many(ctx context.Context, entities []*mdl.PlantTask, mod *hydrator.HydratorMod) error {
	if mod.Contains("plant") {
		this.PlantTaskRelationer.HydratePlant(ctx, entities, nil)
	}
	return nil
}
func (this *PlantTaskHydrator) One(ctx context.Context, entity *mdl.PlantTask, mod *hydrator.HydratorMod) error {
	return this.Many(ctx, []*mdl.PlantTask{entity}, mod)
}
func (this *PlantTaskHydrator) OneViaPreset(ctx context.Context, entity *mdl.PlantTask, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.One(ctx, entity, mod)
}
func (this *PlantTaskHydrator) MustOneViaPreset(ctx context.Context, entity *mdl.PlantTask, preset string, mod *hydrator.HydratorMod) {
	err := this.OneViaPreset(ctx, entity, preset, mod)
	lib.Poe(err)
	return
}
func (this *PlantTaskHydrator) ManyViaPreset(ctx context.Context, entities []*mdl.PlantTask, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.Many(ctx, entities, mod)
}
func (this *PlantTaskHydrator) MustManyViaPreset(ctx context.Context, entities []*mdl.PlantTask, preset string, mod *hydrator.HydratorMod) {
	err := this.ManyViaPreset(ctx, entities, preset, mod)
	lib.Poe(err)
	return
}
func (this *PlantTaskHydrator) presetSwitch(preset string, mod *hydrator.HydratorMod) {
	switch preset {
	case "show":
		this.showPreset(mod)
	case "list":
		this.listPreset(mod)
	default:
		erro.P(erro.N("Invalid preset"))
	}
}
func (this *PlantTaskHydrator) showPreset(mod *hydrator.HydratorMod) {
	this.oneRelations(mod)
}
func (this *PlantTaskHydrator) listPreset(mod *hydrator.HydratorMod) {
	this.selfRelations(mod)
}
func (this *PlantTaskHydrator) selfRelations(mod *hydrator.HydratorMod) {
	mod.AddHydratingPath("plant")
}
func (this *PlantTaskHydrator) oneRelations(mod *hydrator.HydratorMod) {
	mod.AddHydratingPath("plant")
}
