package hydrators

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/error"
	"gardening/src/lib/hydrator"
	"gardening/src/mdl"
	"gardening/src/srv/relationers"
)

type PlantationHydrator struct {
	Hydrator             *hydrator.Hydrator
	PlantationRelationer *relationers.PlantationRelationer
}

func (this *PlantationHydrator) Many(ctx context.Context, entities []*mdl.Plantation, mod *hydrator.HydratorMod) error {
	if mod.Contains("garden_tasks") {
		this.PlantationRelationer.HydrateGardenTasks(ctx, entities, nil)
	}
	if mod.Contains("plant") {
		this.PlantationRelationer.HydratePlant(ctx, entities, nil)
	}
	if mod.Contains("garden") {
		this.PlantationRelationer.HydrateGarden(ctx, entities, nil)
	}
	return nil
}
func (this *PlantationHydrator) One(ctx context.Context, entity *mdl.Plantation, mod *hydrator.HydratorMod) error {
	return this.Many(ctx, []*mdl.Plantation{entity}, mod)
}
func (this *PlantationHydrator) OneViaPreset(ctx context.Context, entity *mdl.Plantation, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.One(ctx, entity, mod)
}
func (this *PlantationHydrator) MustOneViaPreset(ctx context.Context, entity *mdl.Plantation, preset string, mod *hydrator.HydratorMod) {
	err := this.OneViaPreset(ctx, entity, preset, mod)
	lib.Poe(err)
	return
}
func (this *PlantationHydrator) ManyViaPreset(ctx context.Context, entities []*mdl.Plantation, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.Many(ctx, entities, mod)
}
func (this *PlantationHydrator) MustManyViaPreset(ctx context.Context, entities []*mdl.Plantation, preset string, mod *hydrator.HydratorMod) {
	err := this.ManyViaPreset(ctx, entities, preset, mod)
	lib.Poe(err)
	return
}
func (this *PlantationHydrator) presetSwitch(preset string, mod *hydrator.HydratorMod) {
	switch preset {
	case "show":
		this.showPreset(mod)
	case "list":
		this.listPreset(mod)
	default:
		erro.P(erro.N("Invalid preset"))
	}
}
func (this *PlantationHydrator) showPreset(mod *hydrator.HydratorMod) {
	this.oneRelations(mod)
}
func (this *PlantationHydrator) listPreset(mod *hydrator.HydratorMod) {
	this.selfRelations(mod)
}
func (this *PlantationHydrator) selfRelations(mod *hydrator.HydratorMod) {
	mod.AddHydratingPath("plant")
	mod.AddHydratingPath("garden")
}
func (this *PlantationHydrator) oneRelations(mod *hydrator.HydratorMod) {
	mod.AddHydratingPath("plant")
	mod.AddHydratingPath("garden")
}
