package hydrators

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/error"
	"gardening/src/lib/hydrator"
	"gardening/src/mdl"
	"gardening/src/srv/relationers"
)

type SeedProgramHydrator struct {
	Hydrator              *hydrator.Hydrator
	SeedProgramRelationer *relationers.SeedProgramRelationer
}

func (this *SeedProgramHydrator) Many(ctx context.Context, entities []*mdl.SeedProgram, mod *hydrator.HydratorMod) error {
	if mod.Contains("plant") {
		this.SeedProgramRelationer.HydratePlant(ctx, entities, nil)
	}
	return nil
}
func (this *SeedProgramHydrator) One(ctx context.Context, entity *mdl.SeedProgram, mod *hydrator.HydratorMod) error {
	return this.Many(ctx, []*mdl.SeedProgram{entity}, mod)
}
func (this *SeedProgramHydrator) OneViaPreset(ctx context.Context, entity *mdl.SeedProgram, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.One(ctx, entity, mod)
}
func (this *SeedProgramHydrator) MustOneViaPreset(ctx context.Context, entity *mdl.SeedProgram, preset string, mod *hydrator.HydratorMod) {
	err := this.OneViaPreset(ctx, entity, preset, mod)
	lib.Poe(err)
	return
}
func (this *SeedProgramHydrator) ManyViaPreset(ctx context.Context, entities []*mdl.SeedProgram, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.Many(ctx, entities, mod)
}
func (this *SeedProgramHydrator) MustManyViaPreset(ctx context.Context, entities []*mdl.SeedProgram, preset string, mod *hydrator.HydratorMod) {
	err := this.ManyViaPreset(ctx, entities, preset, mod)
	lib.Poe(err)
	return
}
func (this *SeedProgramHydrator) presetSwitch(preset string, mod *hydrator.HydratorMod) {
	switch preset {
	case "show":
		this.showPreset(mod)
	case "list":
		this.listPreset(mod)
	default:
		erro.P(erro.N("Invalid preset"))
	}
}
func (this *SeedProgramHydrator) showPreset(mod *hydrator.HydratorMod) {
	this.oneRelations(mod)
}
func (this *SeedProgramHydrator) listPreset(mod *hydrator.HydratorMod) {
	this.selfRelations(mod)
}
func (this *SeedProgramHydrator) selfRelations(mod *hydrator.HydratorMod) {
	mod.AddHydratingPath("plant")
}
func (this *SeedProgramHydrator) oneRelations(mod *hydrator.HydratorMod) {
	mod.AddHydratingPath("plant")
}
