package hydrators

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/error"
	"gardening/src/lib/hydrator"
	"gardening/src/mdl"
)

type UserHydrator struct {
	Hydrator *hydrator.Hydrator
}

func (this *UserHydrator) Many(ctx context.Context, entities []*mdl.User, mod *hydrator.HydratorMod) error {
	return nil
}
func (this *UserHydrator) One(ctx context.Context, entity *mdl.User, mod *hydrator.HydratorMod) error {
	return this.Many(ctx, []*mdl.User{entity}, mod)
}
func (this *UserHydrator) OneViaPreset(ctx context.Context, entity *mdl.User, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.One(ctx, entity, mod)
}
func (this *UserHydrator) MustOneViaPreset(ctx context.Context, entity *mdl.User, preset string, mod *hydrator.HydratorMod) {
	err := this.OneViaPreset(ctx, entity, preset, mod)
	lib.Poe(err)
	return
}
func (this *UserHydrator) ManyViaPreset(ctx context.Context, entities []*mdl.User, preset string, mod *hydrator.HydratorMod) error {
	mod = this.Hydrator.ModDefaulting(mod)
	this.presetSwitch(preset, mod)
	return this.Many(ctx, entities, mod)
}
func (this *UserHydrator) MustManyViaPreset(ctx context.Context, entities []*mdl.User, preset string, mod *hydrator.HydratorMod) {
	err := this.ManyViaPreset(ctx, entities, preset, mod)
	lib.Poe(err)
	return
}
func (this *UserHydrator) presetSwitch(preset string, mod *hydrator.HydratorMod) {
	switch preset {
	case "show":
		this.showPreset(mod)
	case "list":
		this.listPreset(mod)
	default:
		erro.P(erro.N("Invalid preset"))
	}
}
func (this *UserHydrator) showPreset(mod *hydrator.HydratorMod) {
	this.oneRelations(mod)
}
func (this *UserHydrator) listPreset(mod *hydrator.HydratorMod) {
	this.selfRelations(mod)
}
func (this *UserHydrator) selfRelations(mod *hydrator.HydratorMod) {
}
func (this *UserHydrator) oneRelations(mod *hydrator.HydratorMod) {
}
