package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenPrimaryColumnIllustrer struct {
	GardenStringer *stringers.GardenStringer
	Kit            *kit.Kit
}

type GardenPrimaryColumnIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.Garden
}

func (this *GardenPrimaryColumnIllustrer) Act(ctx context.Context, mod *GardenPrimaryColumnIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
	)
}
func (this *GardenPrimaryColumnIllustrer) text(ctx context.Context, mod *GardenPrimaryColumnIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.GardenStringer.MustToString(mod.Entity))
}
