package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenSearchIllustrer struct {
	GardenStringer *stringers.GardenStringer
	Kit            *kit.Kit
}

type GardenSearchIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.Garden
	Value  *searcher.SearchValue
}

func (this *GardenSearchIllustrer) Act(ctx context.Context, mod *GardenSearchIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
		this.subText(ctx, mod),
	)
}
func (this *GardenSearchIllustrer) text(ctx context.Context, mod *GardenSearchIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.GardenStringer.MustToString(mod.Entity))
}
func (this *GardenSearchIllustrer) subText(ctx context.Context, mod *GardenSearchIllustrerMod) goc.HTML {
	subText := "as Garden"
	if len(mod.Value.Scope) > 0 {
		subText += ", in "
	}
	for _, item := range mod.Value.Scope {
		subText += item.Text
	}
	return goc.H("div", goc.Attr{"class": "text-scale-7 italic"}, subText)
}
