package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenTaskPrimaryColumnIllustrer struct {
	GardenTaskStringer *stringers.GardenTaskStringer
	Kit                *kit.Kit
}

type GardenTaskPrimaryColumnIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.GardenTask
}

func (this *GardenTaskPrimaryColumnIllustrer) Act(ctx context.Context, mod *GardenTaskPrimaryColumnIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
	)
}
func (this *GardenTaskPrimaryColumnIllustrer) text(ctx context.Context, mod *GardenTaskPrimaryColumnIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.GardenTaskStringer.MustToString(mod.Entity))
}
