package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenTaskSearchIllustrer struct {
	GardenTaskStringer *stringers.GardenTaskStringer
	Kit                *kit.Kit
}

type GardenTaskSearchIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.GardenTask
	Value  *searcher.SearchValue
}

func (this *GardenTaskSearchIllustrer) Act(ctx context.Context, mod *GardenTaskSearchIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
		this.subText(ctx, mod),
	)
}
func (this *GardenTaskSearchIllustrer) text(ctx context.Context, mod *GardenTaskSearchIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.GardenTaskStringer.MustToString(mod.Entity))
}
func (this *GardenTaskSearchIllustrer) subText(ctx context.Context, mod *GardenTaskSearchIllustrerMod) goc.HTML {
	subText := "as Garden Task"
	if len(mod.Value.Scope) > 0 {
		subText += ", in "
	}
	for _, item := range mod.Value.Scope {
		subText += item.Text
	}
	return goc.H("div", goc.Attr{"class": "text-scale-7 italic"}, subText)
}
