package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantPrimaryColumnIllustrer struct {
	Kit           *kit.Kit
	PlantStringer *stringers.PlantStringer
}

type PlantPrimaryColumnIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.Plant
}

func (this *PlantPrimaryColumnIllustrer) Act(ctx context.Context, mod *PlantPrimaryColumnIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
	)
}
func (this *PlantPrimaryColumnIllustrer) text(ctx context.Context, mod *PlantPrimaryColumnIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.PlantStringer.MustToString(mod.Entity))
}
