package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantSearchIllustrer struct {
	Kit           *kit.Kit
	PlantStringer *stringers.PlantStringer
}

type PlantSearchIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.Plant
	Value  *searcher.SearchValue
}

func (this *PlantSearchIllustrer) Act(ctx context.Context, mod *PlantSearchIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
		this.subText(ctx, mod),
	)
}
func (this *PlantSearchIllustrer) text(ctx context.Context, mod *PlantSearchIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.PlantStringer.MustToString(mod.Entity))
}
func (this *PlantSearchIllustrer) subText(ctx context.Context, mod *PlantSearchIllustrerMod) goc.HTML {
	subText := "as Plant"
	if len(mod.Value.Scope) > 0 {
		subText += ", in "
	}
	for _, item := range mod.Value.Scope {
		subText += item.Text
	}
	return goc.H("div", goc.Attr{"class": "text-scale-7 italic"}, subText)
}
