package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantTaskPrimaryColumnIllustrer struct {
	Kit               *kit.Kit
	PlantTaskStringer *stringers.PlantTaskStringer
}

type PlantTaskPrimaryColumnIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.PlantTask
}

func (this *PlantTaskPrimaryColumnIllustrer) Act(ctx context.Context, mod *PlantTaskPrimaryColumnIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
	)
}
func (this *PlantTaskPrimaryColumnIllustrer) text(ctx context.Context, mod *PlantTaskPrimaryColumnIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.PlantTaskStringer.MustToString(mod.Entity))
}
