package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantTaskSearchIllustrer struct {
	Kit               *kit.Kit
	PlantTaskStringer *stringers.PlantTaskStringer
}

type PlantTaskSearchIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.PlantTask
	Value  *searcher.SearchValue
}

func (this *PlantTaskSearchIllustrer) Act(ctx context.Context, mod *PlantTaskSearchIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
		this.subText(ctx, mod),
	)
}
func (this *PlantTaskSearchIllustrer) text(ctx context.Context, mod *PlantTaskSearchIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.PlantTaskStringer.MustToString(mod.Entity))
}
func (this *PlantTaskSearchIllustrer) subText(ctx context.Context, mod *PlantTaskSearchIllustrerMod) goc.HTML {
	subText := "as Plant Task"
	if len(mod.Value.Scope) > 0 {
		subText += ", in "
	}
	for _, item := range mod.Value.Scope {
		subText += item.Text
	}
	return goc.H("div", goc.Attr{"class": "text-scale-7 italic"}, subText)
}
