package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantationPrimaryColumnIllustrer struct {
	Kit                *kit.Kit
	PlantationStringer *stringers.PlantationStringer
}

type PlantationPrimaryColumnIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.Plantation
}

func (this *PlantationPrimaryColumnIllustrer) Act(ctx context.Context, mod *PlantationPrimaryColumnIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
	)
}
func (this *PlantationPrimaryColumnIllustrer) text(ctx context.Context, mod *PlantationPrimaryColumnIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.PlantationStringer.MustToString(mod.Entity))
}
