package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantationSearchIllustrer struct {
	Kit                *kit.Kit
	PlantationStringer *stringers.PlantationStringer
}

type PlantationSearchIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.Plantation
	Value  *searcher.SearchValue
}

func (this *PlantationSearchIllustrer) Act(ctx context.Context, mod *PlantationSearchIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
		this.subText(ctx, mod),
	)
}
func (this *PlantationSearchIllustrer) text(ctx context.Context, mod *PlantationSearchIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.PlantationStringer.MustToString(mod.Entity))
}
func (this *PlantationSearchIllustrer) subText(ctx context.Context, mod *PlantationSearchIllustrerMod) goc.HTML {
	subText := "as Plantation"
	if len(mod.Value.Scope) > 0 {
		subText += ", in "
	}
	for _, item := range mod.Value.Scope {
		subText += item.Text
	}
	return goc.H("div", goc.Attr{"class": "text-scale-7 italic"}, subText)
}
