package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeedProgramPrimaryColumnIllustrer struct {
	Kit                 *kit.Kit
	SeedProgramStringer *stringers.SeedProgramStringer
}

type SeedProgramPrimaryColumnIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.SeedProgram
}

func (this *SeedProgramPrimaryColumnIllustrer) Act(ctx context.Context, mod *SeedProgramPrimaryColumnIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
	)
}
func (this *SeedProgramPrimaryColumnIllustrer) text(ctx context.Context, mod *SeedProgramPrimaryColumnIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.SeedProgramStringer.MustToString(mod.Entity))
}
