package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/lib/searcher"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeedProgramSearchIllustrer struct {
	Kit                 *kit.Kit
	SeedProgramStringer *stringers.SeedProgramStringer
}

type SeedProgramSearchIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.SeedProgram
	Value  *searcher.SearchValue
}

func (this *SeedProgramSearchIllustrer) Act(ctx context.Context, mod *SeedProgramSearchIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
		this.subText(ctx, mod),
	)
}
func (this *SeedProgramSearchIllustrer) text(ctx context.Context, mod *SeedProgramSearchIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.SeedProgramStringer.MustToString(mod.Entity))
}
func (this *SeedProgramSearchIllustrer) subText(ctx context.Context, mod *SeedProgramSearchIllustrerMod) goc.HTML {
	subText := "as Seed Program"
	if len(mod.Value.Scope) > 0 {
		subText += ", in "
	}
	for _, item := range mod.Value.Scope {
		subText += item.Text
	}
	return goc.H("div", goc.Attr{"class": "text-scale-7 italic"}, subText)
}
