package illustrers

// |@@| C

import (
	"context"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UserPrimaryColumnIllustrer struct {
	Kit          *kit.Kit
	UserStringer *stringers.UserStringer
}

type UserPrimaryColumnIllustrerMod struct {
	Ctx    context.Context
	Entity *mdl.User
}

func (this *UserPrimaryColumnIllustrer) Act(ctx context.Context, mod *UserPrimaryColumnIllustrerMod) goc.HTML {
	return goc.H("div", goc.Attr{"class": "flex flex-row space-x-1"},
		this.text(ctx, mod),
	)
}
func (this *UserPrimaryColumnIllustrer) text(ctx context.Context, mod *UserPrimaryColumnIllustrerMod) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(this.UserStringer.MustToString(mod.Entity))
}
