package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type CreateGardenJsonView struct {
	GardenSerializer *serializers.GardenSerializer
}

func (this *CreateGardenJsonView) Json(maeOut *maes.CreateGardenMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.gardenToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["item"], err = this.formToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *CreateGardenJsonView) gardenToJson(maeOut *maes.CreateGardenMaeOut) (json.RawMessage, error) {
	return this.GardenSerializer.OneToJson(maeOut.Response.Garden)
}
func (this *CreateGardenJsonView) formBagToJson(maeOut *maes.CreateGardenMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *CreateGardenJsonView) formToJson(maeOut *maes.CreateGardenMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.Form)
}
func (this *CreateGardenJsonView) formFieldsToJson(maeOut *maes.CreateGardenMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
