package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type CreateGardenTaskJsonView struct {
	GardenTaskSerializer *serializers.GardenTaskSerializer
}

func (this *CreateGardenTaskJsonView) Json(maeOut *maes.CreateGardenTaskMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.gardenTaskToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["item"], err = this.formToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *CreateGardenTaskJsonView) gardenTaskToJson(maeOut *maes.CreateGardenTaskMaeOut) (json.RawMessage, error) {
	return this.GardenTaskSerializer.OneToJson(maeOut.Response.GardenTask)
}
func (this *CreateGardenTaskJsonView) formBagToJson(maeOut *maes.CreateGardenTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *CreateGardenTaskJsonView) formToJson(maeOut *maes.CreateGardenTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.Form)
}
func (this *CreateGardenTaskJsonView) formFieldsToJson(maeOut *maes.CreateGardenTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
