package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type CreatePlantJsonView struct {
	PlantSerializer *serializers.PlantSerializer
}

func (this *CreatePlantJsonView) Json(maeOut *maes.CreatePlantMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.plantToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["item"], err = this.formToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *CreatePlantJsonView) plantToJson(maeOut *maes.CreatePlantMaeOut) (json.RawMessage, error) {
	return this.PlantSerializer.OneToJson(maeOut.Response.Plant)
}
func (this *CreatePlantJsonView) formBagToJson(maeOut *maes.CreatePlantMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *CreatePlantJsonView) formToJson(maeOut *maes.CreatePlantMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.Form)
}
func (this *CreatePlantJsonView) formFieldsToJson(maeOut *maes.CreatePlantMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
