package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type CreatePlantTaskJsonView struct {
	PlantTaskSerializer *serializers.PlantTaskSerializer
}

func (this *CreatePlantTaskJsonView) Json(maeOut *maes.CreatePlantTaskMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.plantTaskToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["item"], err = this.formToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *CreatePlantTaskJsonView) plantTaskToJson(maeOut *maes.CreatePlantTaskMaeOut) (json.RawMessage, error) {
	return this.PlantTaskSerializer.OneToJson(maeOut.Response.PlantTask)
}
func (this *CreatePlantTaskJsonView) formBagToJson(maeOut *maes.CreatePlantTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *CreatePlantTaskJsonView) formToJson(maeOut *maes.CreatePlantTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.Form)
}
func (this *CreatePlantTaskJsonView) formFieldsToJson(maeOut *maes.CreatePlantTaskMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
