package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type CreatePlantationJsonView struct {
	PlantationSerializer *serializers.PlantationSerializer
}

func (this *CreatePlantationJsonView) Json(maeOut *maes.CreatePlantationMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.plantationToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["item"], err = this.formToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *CreatePlantationJsonView) plantationToJson(maeOut *maes.CreatePlantationMaeOut) (json.RawMessage, error) {
	return this.PlantationSerializer.OneToJson(maeOut.Response.Plantation)
}
func (this *CreatePlantationJsonView) formBagToJson(maeOut *maes.CreatePlantationMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *CreatePlantationJsonView) formToJson(maeOut *maes.CreatePlantationMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.Form)
}
func (this *CreatePlantationJsonView) formFieldsToJson(maeOut *maes.CreatePlantationMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
