package json_views

// |@@| C

import (
	"encoding/json"
	"gardening/src/dat/maes"
	"gardening/src/srv/serializers"
)

type CreateUserJsonView struct {
	UserSerializer *serializers.UserSerializer
}

func (this *CreateUserJsonView) Json(maeOut *maes.CreateUserMaeOut) ([]byte, error) {
	m := make(map[string]interface{})
	var err error
	if maeOut.Success == false {
		m["messages"] = maeOut.Extra.Messages
		m["form_bag"] = maeOut.Response.FormBag
		return json.Marshal(m)
	}
	m["item"], err = this.userToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_bag"], err = this.formBagToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["item"], err = this.formToJson(maeOut)
	if err != nil {
		return nil, err
	}
	m["form_fields"], err = this.formFieldsToJson(maeOut)
	if err != nil {
		return nil, err
	}
	return json.Marshal(m)
}
func (this *CreateUserJsonView) userToJson(maeOut *maes.CreateUserMaeOut) (json.RawMessage, error) {
	return this.UserSerializer.OneToJson(maeOut.Response.User)
}
func (this *CreateUserJsonView) formBagToJson(maeOut *maes.CreateUserMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormBag)
}
func (this *CreateUserJsonView) formToJson(maeOut *maes.CreateUserMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.Form)
}
func (this *CreateUserJsonView) formFieldsToJson(maeOut *maes.CreateUserMaeOut) (json.RawMessage, error) {
	return json.Marshal(maeOut.Response.FormFields)
}
